<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use Core\Model\Http\Session;
use Core\Model\UI\FrontPresenter;
use Currency\Model\Currencies;
use EshopOrders\FrontModule\Components\Order\OrderForm;
use EshopOrders\FrontModule\Model\Customers;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Users\Model\Event\UserEvent;

class PresenterSubscriber implements EventSubscriberInterface
{
	protected Currencies $currenciesService;
	protected Customers  $customers;
	protected Session    $session;

	public function __construct(
		Currencies $currencies,
		Customers  $customers,
		Session    $session
	)
	{
		$this->currenciesService = $currencies;
		$this->customers         = $customers;
		$this->session           = $session;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			FrontPresenter::class . '::startup' => 'startup',
			'user.logout'                       => 'logout',
		];
	}

	public function startup(ControlEvent $event): void
	{
	}

	public function logout(UserEvent $event): void
	{
		$session                = $this->session->getSection(OrderForm::sessionNamespace);
		$session->orderFormData = [];
	}
}
