<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Subscribers;

use EshopOrders\FrontModule\Model\Customers;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Users\Model\Event\UserEvent;

class RegisterFormSubscriber implements EventSubscriberInterface
{
	protected Customers $customers;

	public function __construct(
		Customers $customers
	)
	{
		$this->customers = $customers;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'users.registerForm.afterSave' => 'afterSave',
		];
	}

	public function afterSave(UserEvent $event): void
	{
		$user     = $event->user;
		$customer = $this->customers->getOrCreateCustomer($user->getId(), $user->getEmail(), $user->getName(), $user->getLastname());
	}
}
