<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Invoice;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\IDiscount;

/**
 * @ORM\Table("eshop_orders__invoice_discount")
 * @ORM\Entity
 */
class Discount implements IDiscount
{
	use TId;

	/**
	 * @ORM\Column(type="string")
	 */
	public ?string $code = null;

	/**
	 * @ORM\Column(name="name", type="string")
	 */
	public ?string $name = null;

	/** sleva v procentech nebo pevna castka
	 * @var int|float|null
	 * @ORM\Column(type="integer")
	 */
	public $value;

	/** vysledna sleva vypocitana z procent - zaporna hodnota
	 * @var float|string|null
	 * @ORM\Column(type="decimal", precision=10, scale=2)
	 */
	public $price;

	/** procenta / fixni castka
	 * @ORM\Column(type="string")
	 */
	public ?string $type = null;

	/**
	 * @ORM\ManyToOne(targetEntity="InvoiceData", inversedBy="discounts", cascade={"persist"})
	 * @ORM\JoinColumn(name="invoice_data_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected InvoiceData $invoiceData;

	public function __construct(InvoiceData $invoiceData)
	{
		$this->invoiceData = $invoiceData;
	}

	public function getValue(): float { return $this->value; }

	public function getType(): string { return $this->type; }

	public function calculateDiscount(float $price): float { return -abs((float) $this->value); }
}
