<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Invoice;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_orders__invoice_spedition")
 * @ORM\Entity
 */
class Spedition
{
	use TId;

	/**
	 * @ORM\Column(type="integer", options={"unsigned": true})
	 */
	public ?string $speditionId = null;

	/**
	 * @ORM\Column(type="string")
	 */
	public ?string $name = null;

	/**
	 * @var float|string
	 * @ORM\Column(type="decimal", precision=10, scale=2)
	 */
	protected $price;

	/**
	 * @ORM\OneToOne(targetEntity="InvoiceData", mappedBy="spedition")
	 */
	public InvoiceData $invoiceData;

	/**
	 * @ORM\Column(name="vat_rate", type="smallint", nullable=true)
	 */
	protected ?int $vatRate = null;

	/** @param float|string $price */
	public function setPrice($price): void { $this->price = (string) $price; }

	public function getPrice(): float
	{
		return (float) $this->price;
	}

	public function getPriceWithoutVat(): float
	{
		$vatRate = $this->getVatRate();

		if ($vatRate === 0) {
			return (float) $this->price;
		}

		$vatRate = ($vatRate / 100) + 1;

		return round((float) $this->price / $vatRate, 2);
	}

	public function setVatRate(int $vatRate): void { $this->vatRate = $vatRate; }

	public function getVatRate(): int { return $this->invoiceData && $this->invoiceData->zeroVat ? 0 : ($this->vatRate ?? 21); }
}
