<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Utils\Helpers;
use EshopOrders\Model\Utils\Strings;
use Nette\Utils\Arrays;

/**
 * @ORM\Table("eshop_orders__numerical_series")
 * @ORM\Entity
 */
class NumericalSeries
{
	use TId;

	/** @var array */
	public const POSSIBLE_PREFIX_WILDCARDS = [
		'year'  => ['YYYY', 'YY'],
		'month' => ['MM'],
	];

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $prefix;

	/**
	 * @ORM\Column(type="integer", nullable=false)
	 */
	public int $digitsCount;

	/**
	 * @ORM\Column(type="integer", nullable=false)
	 */
	public int $startNumber;

	public function __construct(string $prefix, int $digitsCount, int $startNumber)
	{
		$this->prefix      = $prefix;
		$this->digitsCount = $digitsCount;
		$this->startNumber = $startNumber;
	}

	public function getRealPrefix(): string
	{
		return Helpers::replaceTimeWildcards($this->prefix, Arrays::flatten(self::POSSIBLE_PREFIX_WILDCARDS));
	}

	public function increaseStartNumber(): void
	{
		if (((int) \Nette\Utils\Strings::padRight('9', $this->digitsCount, '9')) === $this->startNumber) {
			return;
		}

		$this->startNumber++;
	}

	public function containsPrefixYearWildcards(): bool
	{
		return Strings::containsMore($this->prefix, self::POSSIBLE_PREFIX_WILDCARDS['year']);
	}

	public function containsPrefixMonthWildcards(): bool
	{
		return Strings::containsMore($this->prefix, self::POSSIBLE_PREFIX_WILDCARDS['month']);
	}
}
