<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table("eshop_orders__order_card_payment_token")
 * @ORM\Entity
 */
class OrderCardPaymentToken
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Order $order;

	/**
	 * @ORM\Column(name="note", type="string", length=255, nullable=true)
	 */
	public ?string $note = null;

	/**
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	protected \DateTime $created;

	/**
	 * @var ArrayCollection<OrderCardPaymentHistory>
	 * @ORM\OneToMany(targetEntity="OrderCardPaymentHistory", mappedBy="token")
	 */
	protected Collection $history;

	/**
	 * @ORM\Column(name="param", type="string", nullable=true)
	 */
	public ?string $param = null;

	public function __construct(Order $order)
	{
		$this->order   = $order;
		$this->created = new \DateTime();
		$this->history = new ArrayCollection();
	}

	public function getToken(): int { return $this->getId(); }

	public function getCreated(): \DateTime { return $this->created; }

	/** @return ArrayCollection<OrderCardPaymentHistory> */
	public function getHistory() { return $this->history; }
}
