<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_orders__order_flag",
 *      uniqueConstraints={@ORM\UniqueConstraint(name="order_flag_unique",columns={"order_id", "type"} )}
 *     )
 * @ORM\Entity
 */
class OrderFlag
{
	public const TYPE_QUESTIONING        = 'agreed_questioning';
	public const TYPE_NEWSLETTER         = 'agreed_newsletter';
	public const TYPE_INVOICE_SENT       = 'invoice_sent';
	public const TYPE_SURVEY             = 'survey';
	public const TYPE_REQUEST_FOR_REVIEW = 'request_for_review';

	use TId;

	/**
	 * druh priznaku (napr "agreed_questioning" - souhlas s dotaznikem spokojenosti)
	 * @ORM\Column(name="type", type="string")
	 */
	protected string $type;

	/**
	 * @ORM\Column(name="state", type="boolean", nullable=true)
	 */
	protected int $state = 0;

	/**
	 * @ORM\ManyToOne(targetEntity="Order", inversedBy="orderFlags", cascade={"persist"})
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Order $order;

	/** @param string|int|bool $state */
	public function __construct(string $type, $state, Order $order)
	{
		$this->type  = $type;
		$this->state = (int) $state;
		$this->order = $order;
	}

	public function getType(): string { return $this->type; }

	public function setType(string $type): OrderFlag
	{
		$this->type = $type;

		return $this;
	}

	public function getState(): int { return $this->state; }

	/** @param string|int|bool $state */
	public function setState($state): OrderFlag
	{
		$this->state = (int) $state;

		return $this;
	}

	public function getOrder(): Order { return $this->order; }

	public function setOrder(Order $order): OrderFlag
	{
		$this->order = $order;

		return $this;
	}
}

