<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("eshop_orders__order_paid_history")
 * @ORM\Entity
 */
class OrderPaidHistory
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Order", inversedBy="payment")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Order $order;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $text;

	/**
	 * @var \DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	public \DateTime $created;

	/**
	 * @ORM\Column(type="smallint", options={"default": 0})
	 */
	public int $isDeleted = 0;

	public function __construct(Order $order, string $text)
	{
		$this->created = new DateTime;
		$this->order   = $order;
		$this->text    = $text;
	}

	public function getCreated(): \DateTime { return $this->created; }
}
