<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Nette\Utils\DateTime;
use Users\Model\Entities\User;

/**
 * @ORM\Table("eshop_orders__order_status_history")
 * @ORM\Entity
 */
class OrderStatusHistory implements IOrderStatus
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Order $order;

	/**
	 * @ORM\ManyToOne(targetEntity="Status")
	 * @ORM\JoinColumn(name="status_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Status $status;

	/**
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	protected \DateTime $created;

	/**
	 * @ORM\ManyToOne(targetEntity="\Users\Model\Entities\User")
	 * @ORM\JoinColumn(name="created_by", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected ?User $createdBy = null;

	public function __construct(Order $order, Status $status, ?User $createdBy = null)
	{
		$this->order     = $order;
		$this->status    = $status;
		$this->createdBy = $createdBy;
		$this->created   = new DateTime;
	}

	public function getOrder(): Order { return $this->order; }

	public function getStatus(): Status { return $this->status; }

	public function getCreated(): \DateTime { return $this->created; }

	public function getCreatedBy(): ?User { return $this->createdBy; }
}
