<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Helpers\Strings;
use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_orders__spedition_price_level")
 */
class SpeditionPriceLevel
{

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Spedition", inversedBy="priceLevels", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="spedition_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private Spedition $spedition;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="GroupCustomers")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private GroupCustomers $group;

	/**
	 * @var float|string
	 * @ORM\Column(name="price", type="decimal", precision=10, scale=2, nullable=false)
	 */
	protected $price;

	/**
	 * @ORM\Column(name="free_from", type="integer", nullable=true)
	 */
	public ?int $freeFrom = null;

	/**
	 * @ORM\Column(name="available_from", type="integer", nullable=true)
	 */
	public ?int $availableFrom = null;

	/**
	 * @ORM\Column(name="available_to", type="integer", nullable=true)
	 */
	public ?int $availableTo = null;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public ?DateTimeInterface $freeFromDate = null;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public ?DateTimeInterface $freeToDate = null;

	public function __construct(Spedition $spedition, GroupCustomers $group, float $price)
	{
		$this->spedition = $spedition;
		$this->group     = $group;
		$this->setPrice($price);
	}

	public function getSpedition(): Spedition { return $this->spedition; }

	public function getGroup(): GroupCustomers { return $this->group; }

	public function getPrice(): float { return (float) $this->price; }

	public function setPrice(float $price): void
	{
		$this->price = (string) Strings::formatEntityDecimal($price);
	}
}
