<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Core\Model\Helpers\Strings;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table("eshop_orders__status")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class Status
{
	use TTranslateListener;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="id", type="string")
	 */
	protected string $id;

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	protected ?int $position = null;

	/**
	 * @ORM\Column(name="send_to_customer", type="smallint", nullable=false, options={"unsigned": true, "default": 1})
	 */
	public int $sendToCustomer = 1;

	/**
	 * @ORM\Column(name="is_locked", type="smallint", nullable=false, options={"unsigned": true, "default": 1})
	 */
	public int $isLocked = 1;

	/**
	 * @var ArrayCollection<StatusText>
	 * @ORM\OneToMany(targetEntity="StatusText", mappedBy="status", indexBy="lang")
	 */
	public Collection $texts;

	public function __construct(string $id)
	{
		$this->setId($id);
		$this->setPosition(-1);
		$this->texts = new ArrayCollection();
	}

	public function getId(): string { return $this->id; }

	public function setId(string $id): Status
	{
		$this->id = Strings::toCamelCase($id);

		return $this;
	}

	public function getName(): ?string
	{
		$text = $this->getText();

		return $text->name ?? null;
	}

	public function setName(string $name): Status
	{
		$text = $this->getText();
		if ($text) {
			$text->name = $name;
		}

		return $this;
	}

	public function getPosition(): int { return $this->position; }

	public function setPosition(int $position): Status
	{
		$this->position = $position;

		return $this;
	}

	public function getText(?string $lang = null): ?StatusText
	{
		return $this->texts->get($lang ?: $this->locale) ?? $this->texts->first();
	}
}
