if (!global.document.autocompleteResultItem)
	global.document.autocompleteResultItem = {};

global.document.autocompleteResultItem['orderItemAddForm-product'] = (data, source) => {
	source.innerHTML = data.value.code1 + ' | ' + data.value.name;
};

document.addEventListener('autocompleteOnSelection', e => {
	if (e.detail.name == 'orderItemAddForm-product') {
		const input = document.querySelector('[data-autocomplete-name="' + e.detail.name + '"]');
		const form  = document.querySelector('.orderItemAddForm');
		const data  = e.detail.selection.value;

		if (form) {
			form.querySelector('[name="code1"]').value = data.code1;

			global.naja.makeRequest('get', input.dataset.detailLink.replace('__id__', data.id), {}, {
				history: false
			}).then(response => {
				form.querySelector('[name="price"]').value       = response.price;
				form.querySelector('[name="productName"]').value = response.name;
				form.querySelector('[name="vatRate"]').value     = response.vatRate;
			});
		}
	}
});

const productInput = document.getElementById('frm-orderItemAddForm-form-product');

if (productInput) {
	productInput.setAttribute('tab-index', '0');

	setTimeout(() => {
		productInput.focus();
	}, 300);
}
