import {scrollTo}           from 'core/js/utils/utilities';
import {slideDown, slideUp} from "es6-slide-up-down";
import {Autocomplete}       from "core/js/components/autocomplete";

const autocomplete = new Autocomplete();

const Nette = window.Nette;

let oldValidateControl = Nette.validateControl;
let oldValidateForm    = Nette.validateForm;
let lastError          = false;
let actualStep         = 1;
let validatedSteps     = {
	1: true,
	2: false,
	3: false,
	4: false,
};

const showStep = (step) => {
	if (step === undefined)
		return;

	actualStep           = step;
	validatedSteps[step] = true;
	step                 = step.toString();
	document.querySelectorAll('[data-visible-step]').forEach((el) => {
		if (el.dataset.visibleStep.split(',').includes(step) === true)
			el.style.display = 'block';
		else
			el.style.display = 'none';
	});

	document.querySelectorAll('[data-cart-step]').forEach((el) => {
		let parent = el.parentElement;
		if (el.dataset.cartStep == step)
			parent.classList.add('active');
		else
			parent.classList.remove('active');
	});
};

const addValidStep = (step) => {
	step                 = step.toString();
	validatedSteps[step] = true;

	updateValidSteps();
};

const removeValidStep = (step) => {
	validatedSteps[step] = false;

	while (step <= 4) {
		validatedSteps[step] = false;
		step++;
	}

	updateValidSteps();
};

const updateValidSteps = () => {
	let lastStatus = true;
	for (let i = 1; i <= 4; i++) {
		let el     = document.querySelector('[data-cart-step="' + i + '"]');
		let parent = el.parentElement;

		if (validatedSteps[i] === true || parseInt(actualStep) === i) {
			parent.classList.remove('invalid');
		} else {
			parent.classList.add('invalid');
		}
	}
};

const getCurrentStepFromInput = (input) => {
	let i      = 0;
	let parent = input;

	while (parent && parent.dataset.visibleStep === undefined && i < 25) {
		parent = parent.parentElement;
		i++;
	}

	return parent && parent.dataset && parent.dataset.visibleStep !== undefined ? parent.dataset.visibleStep : null;
};

const getCurrentStepFromNav = () => {
	let activeStep = document.querySelector('[data-cart-steps] .active [data-cart-step]');
	if (activeStep)
		return parseInt(activeStep.dataset.cartStep);
};

const showError = (elem) => {
	lastError      = elem;
	let step       = getCurrentStepFromInput(elem);
	let firstError = document.querySelector('[data-visible-step="' + step + '"] .has-error');

	if (!firstError) {
		let alertEl = document.querySelector('#frm-orderForm-form .alert');

		if (alertEl)
			firstError = alertEl;
	}

	scrollTo(firstError.offsetTop, 250);
};

Nette.validateControl = (elem, rules, onlyCheck, value, emptyOptional) => {
	let result = oldValidateControl(elem, rules, onlyCheck, value, emptyOptional);

	// UI vizualizace chyby dopravy a platby
	if (['spedition', 'payment'].includes(elem.name)) {
		let box = elem.parentElement.parentElement.parentElement;
		if (elem.classList.contains('has-error'))
			box.classList.add('has-error');
		else
			box.classList.remove('has-error');
	}

	if (!result && !lastError) {
		showError(elem);
	}

	document.querySelectorAll('[data-visible-step]').forEach(wrap => {
		let errorsSnippet = wrap.querySelector('[id*="snippet-orderForm-formErrors"]');

		if (!errorsSnippet)
			return true;

		let errors = '';
		wrap.querySelectorAll('.frm__input-error').forEach(errorEl => {
			errors += '<div>' + errorEl.innerHTML + '</div>';
		});

		if (errors === '')
			errorsSnippet.innerHTML = '';
		else
			errorsSnippet.innerHTML = '<div class="alert alert-danger" role="alert">' + errors + '</div>';
	});

	return result;
};

const initSpeditionPaymentClick = () => {
	let speditionCountrySelect = document.querySelector('[name="speditionCountry"]');
	let allSpeditionsPayments  = document.querySelectorAll('#csp .csp__item');
	let speditions             = document.querySelectorAll('input[id^="frm-orderForm-form-speditions-"]');
	let payments               = document.querySelectorAll('input[id^="frm-orderForm-form-payments-"]');
	let obj                    = {'sped': speditions, 'pay': payments};

	for (let key in obj) {
		let list        = obj[key];
		let secondLlist = key == 'sped' ? payments : speditions;
		list.forEach(function (el) {
			let initClick = true;

			if (el.clickInited === true) {
				return;
			}

			el.addEventListener('click', (e) => {
				let a               = e.target;

				let selectedCountry = speditionCountrySelect.value;

				if (a.dataset.lastStatus == 'true') {
					list.forEach((v) => {
						v.checked            = false;
						v.dataset.lastStatus = false;
					});

					secondLlist.forEach((v) => {
						let parent = v.closest('[data-country]');

						if (parent.dataset.country !== selectedCountry)
							return true;
						parent.classList.remove('disabled');
					});
				} else {
					let ids              = a.dataset.allowed.split(',');
					a.dataset.lastStatus = a.checked;

					list.forEach((v) => {
						if (v.id == a.id)
							return true;
						v.dataset.lastStatus = false;
					});

					secondLlist.forEach((v) => {
						let parent = v.closest('[data-country]');

						if (parent.dataset.country !== selectedCountry)
							return true;

						console.log(v.value);

						if (!ids.includes(v.value)) {
							if (!initClick || v.initRunRemoved !== true)
								parent.classList.add('disabled');
						} else {
							parent.classList.remove('disabled');
							v.initRunRemoved = true;
						}
					});
				}
			});

			el.clickInited = true;

			if (el.checked)
				el.click({initClick: true});

			initClick = false;
		});
	}
}

document.addEventListener('DOMContentLoaded', () => {
	// Krokovani stránek
	showStep(actualStep);

	// Discount code
	const discountForm = document.querySelector('[id*="discountForm-form"]');
	if (discountForm) {
		const input  = discountForm.querySelector('input');
		const button  = discountForm.querySelector('button');
		input.addEventListener('input', e => {
			if (input.value) {
				button.classList.remove('darkest-grey-bg-color');
				button.classList.add('primary-bg-color');
			} else {
				button.classList.add('darkest-grey-bg-color');
				button.classList.remove('primary-bg-color');
			}
		});
	}

	// Zaškrtnutí/odškrtnutí dopravy a platby
	initSpeditionPaymentClick();

	initSpeditionCountrySelect();

	document.addEventListener('click', e => {
		const target = e.target;
		let el       = null;

		// Remove item from cart
		el = target.closest('[data-remove-item]');
		if (el !== null) {
			if (el.dataset.link !== undefined) {
				global.naja.makeRequest('get', el.dataset.link, {}, {});
			} else {
				let input   = document.querySelector('input[data-item-id="' + el.dataset.item + '"]');
				input.value = 0;
				input.removeAttribute('data-nette-rules');
				input.dispatchEvent(new Event('change'));

				e.preventDefault();
			}
		}
	});

	initStepButtons();
	initFreeDeliveryBar();
	checkCollapse();
	global.naja.addEventListener('success', (e) => {
		// Validace orderForm na serveru
		if (e.response.orderFormErrors !== undefined || e.response.orderFormIsValid == false) {
			const errs        = e.response.orderFormErrors;
			const fieldErrors = e.response.fieldErrors;
			let firstError    = null;

			try {
				for (let key in fieldErrors) {
					fieldErrors[key].forEach(e => {
						Nette.addError(document.querySelector('[name="' + key + '"]'), e);
					});
				}
			} catch (e) {
			}

			try {
				for (let key in errs) {
					let el = document.getElementById(key);

					if (firstError === null)
						firstError = el;

					errs[key].forEach((e) => {
						Nette.addError(el, e);
					})
				}
			} catch (e) {
			}

			showError(firstError);
			// showStep(getCurrentStepFromNav());
		} else if (e.response.orderFormIsValid == true) {
			const currentStep = getCurrentStepFromNav();

			showStep(currentStep + 1);
			addValidStep(currentStep);
			scrollTo(0, 250);
		} else {
			showStep(getCurrentStepFromNav());
		}
	});
	global.naja.addEventListener('complete', (e) => {
		initStepButtons();
		initFreeDeliveryBar();
		checkCollapse();
		initSpeditionCountrySelect();
		initSpeditionPaymentClick();
	});

	// Přesměrování na platební bránu
	const paymentGatewayWrap = document.querySelector('[data-payment-gateway-wrap]');
	if (paymentGatewayWrap) {
		const paymentBtn = document.querySelector('[data-payment-gateway-btn]');
		setTimeout(function () {
			paymentBtn.classList.add('disabled');
		}, 2800);

		setTimeout(function () {
			paymentBtn.click();
		}, 3000);

		setTimeout(function () {
			paymentBtn.classList.remove('disabled');
		}, 5000);
	}
});

document.cartNoteOldValue = {};
document.querySelectorAll('.cd__col-name-note textarea').forEach(el => {
	document.cartNoteOldValue[el.id] = el.value;
});

document.addEventListener('focusout', e => {
	const target = e.target;
	const parent = target.parentElement;

	if (parent && parent.classList.contains('cd__col-name-note')) {
		const form = parent.closest('form');

		if (form && document.cartNoteOldValue[target.id] != target.value) {
			global.naja.makeRequest('post', form.action, new FormData(form), {
				history: false,
			}).then(resp => {
				document.cartNoteOldValue[target.id] = target.value;
			});
		}
	}
});

document.addEventListener('change', e => {
	const target = e.target;

	if (target.getAttribute('name') === 'speditionCountry' && target.dataset.changeLink) {
		global.naja.makeRequest('post', target.dataset.changeLink, {
			speditionCountry: target.value,
		}, {
			history: false,
		});
	}
})

document.addEventListener('click', e => {
	const target = e.target

	if (target.parentElement?.classList.contains('subselect-wrap')) {
		const el = target.closest('.csp__item')?.querySelector('[name^=speditions]')

		if (el) {
			el.checked = true;
		}
	}
})

// Spedition country select
const initSpeditionCountrySelect = () => {
	let speditionCountrySelect = document.querySelector('[name="speditionCountry"]');
	let allSpeditionsPayments  = document.querySelectorAll('#csp .csp__item');
	let allCaptions = document.querySelectorAll('#csp .csp__caption');
	if (speditionCountrySelect) {
		speditionCountrySelect.addEventListener('change', e => {
			let val = speditionCountrySelect.value;

			allSpeditionsPayments.forEach(el => {
				if (el.dataset.country == val)
					el.classList.remove('hidden');
				else
					el.classList.add('hidden');
			})

			allCaptions.forEach(el => {
				if (el.dataset.country == val)
					el.classList.remove('hidden');
				else
					el.classList.add('hidden');
			})
		});
	}
}

// Free delivery bar
let initPercent           = 0;
const initFreeDeliveryBar = () => {
	let freeDelivery         = document.querySelector('[data-free-delivery-bar-wrap]');
	let freeDeliveryProgress = document.querySelector('[data-free-delivery-progress]');
	let newPercent           = 0;

	if (freeDeliveryProgress) {
		freeDeliveryProgress.style.width = initPercent + '%';
		setTimeout(function () {
			initPercent                      = parseFloat(freeDelivery.dataset.percent);
			freeDeliveryProgress.style.width = initPercent + '%';
		}, initPercent === 0 ? 1000 : 250);
	} else if (freeDelivery) {
		initPercent = parseFloat(freeDelivery.dataset.percent);
	}
};

// Tlačítka na stránky
const initStepButtons = () => {
	document.querySelectorAll('a[data-cart-go-to]:not(.init), a[data-cart-step]:not(.init)').forEach((el) => {
		el.classList.add('init');
		el.addEventListener('click', (e) => {
			e.stopImmediatePropagation();
			let step = el.dataset.cartGoTo !== undefined ? el.dataset.cartGoTo : el.dataset.cartStep;
			showStep(step);
			updateValidSteps();
			scrollTo(0);
		});
	});
};

const checkCollapse = () => {
	// Kliknutí na data-collapse
	document.querySelectorAll('[data-collapse]:not(.init)').forEach((el) => {
		el.classList.add('init');
		el.addEventListener('click', () => {
			el.classList.toggle('active');

			let target = document.getElementById(el.dataset.collapse);
			if (target) {
				if (window.getComputedStyle(target).display === 'none')
					slideDown(target);
				else
					slideUp(target);
			}
		});
	});

	// Změna data-check-collapse
	document.querySelectorAll('[data-check-collapse]:not(.init)').forEach((el) => {
		let input = document.getElementById(el.getAttribute('for'));
		if (input.getAttribute('required') !== null && input.checked) {
			el.addEventListener('change', e => {
				input.checked = true;
				e.preventDefault();
				return false
			});
		} else {
			el.addEventListener('change', (e) => {
				let target = document.getElementById(el.dataset.checkCollapse);
				let input  = el;
				if (input.tagName == 'LABEL')
					input = document.getElementById(el.getAttribute('for'));
				if (target) {
					if (input.checked)
						slideDown(target);
					else
						slideUp(target);
				}
			});
		}
	});
}

document.addEventListener('change', e => {
	const target = e.target;

	const attrName = target.getAttribute('name');
	if (attrName && attrName.indexOf('speditions') === 0) {
		target.closest('.csp__item').querySelectorAll('input').forEach(input => {
			const inputType = input.getAttribute('type');
			if (inputType !== 'text' && inputType !== 'select')
				return true;

			input.focus();
			input.click();
		});
	}

	if (attrName && attrName === 'invoiceAddressesList' || attrName === 'deliveryAddressesList') {
		try {
			if (target.value == '')
				return;
			const data       = JSON.parse(target.dataset.list)[target.value];
			const nameSuffix = target.dataset.nameSuffix;

			['firstName', 'lastName', 'phone', 'email', 'street', 'city', 'postal', 'country', 'company', 'idNumber', 'vatNumber'].forEach(v => {
				const name = v + nameSuffix;

				let input = document.querySelector('[name="' + name + '"]');
				if (input)
					input.value = data[v];
			});
		} catch (e) {
			console.log(e);
		}
	}
});
