<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\DashboardWidgets;

use Dashboard\AdminModule\Model\Provider\IWidget;
use EshopOrders\AdminModule\Model\Statistics;

class OrdersSales extends BaseEshopOrdersWidget implements IWidget
{
	protected string $gridSize = 'col-md-4 col-xxl-3';

	protected string $key = 'eshopOrdersOrdersSales';

	/** @var Statistics\Overview|null @inject */
	public ?Statistics\Overview $overview = null;

	public function render(): void
	{
		$this->template->key   = $this->key;
		$this->template->icon  = 'fas fa-coins';
		$this->template->title = $this->t('eshopOrders.dashboardWidget.sales.title');

		$data                    = $this->overview->getOrdersSales();
		$this->template->value   = $this->priceFilter->format((float) $data['count']);
		$this->template->percent = $data['percent'];

		$this->template->baseTemplate = $this->baseTemplate;
		$this->template->render($this->getTemplateFile());
	}
}
