<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\OrderInvoice;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Invoices;
use Nette\Utils\ArrayHash;

class OrderInvoiceForm extends BaseControl
{
	protected Order    $order;
	protected Invoices $invoices;

	public function __construct(
		Order    $order,
		Invoices $invoices
	)
	{
		$this->order    = $order;
		$this->invoices = $invoices;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false);
		$form->setAjax();

		$defaultLang = $this->order->getInvoice()
			? $this->order->getInvoice()->invoiceData->lang
			: $this->order->getParam('invoiceLang');

		$form->addSelect('lang', 'eshopOrders.order.invoiceLang', $this->langsService->getOptionsForSelect())
			->setDefaultValue($defaultLang ?: $this->order->lang)
			->setRequired();
		$form->addSubmit('save', 'default.save')
			->setHtmlAttribute('data-confirm', $this->t('default.reallyConfirm'));

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		try {
			$invoice = $this->order->getInvoice();
			if ($invoice) {
				$invoice->invoiceData->lang = $values->lang;

				$this->em->persist($invoice->invoiceData);

				$this->invoices->regenerateInvoice($invoice->getId());
			} else {
				$this->order->setParam('invoiceLang', $values->lang);

				$this->em->persist($this->order);
			}

			$this->em->flush();
			//			$this->presenter->redirect('this');
		} catch (\Exception $e) {
			$form->addError($e->getMessage());
			$this->redrawControl('form');
		}
	}
}
