<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Entities\EntityManagerDecorator;

class Expedition
{
	protected EntityManagerDecorator $em;

	public function __construct(
		EntityManagerDecorator $em
	)
	{
		$this->em = $em;
	}

	public function clearOldLog(): void
	{
		$date = (new \DateTime())->modify('-7 days')->setTime(0, 0, 0)->format('Y-m-d H:i:s');
		$this->em->getConnection()->executeQuery("DELETE FROM eshop_orders__order_expedition_log WHERE created < '$date'");
	}
}
