<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\Model\Invoices;
use EshopOrders\Model\Pdf\IInvoicePdfBuilderFactory;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	/** @var Invoices @inject */
	public $invoices;

	/** @var IInvoicePdfBuilderFactory @inject */
	public $invoicePdfBuilderFactory;

	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);

		// Povolit pokud je pouze pristup na faktury
		if (
			($this->getName() === 'EshopOrders:Admin:Invoice' || $this->getAction(true) === ':EshopOrders:Admin:Orders:invoice')
			&& $this->getUser()->isAllowed('EshopOrders:Admin:Invoice', 'access')) {
			return;
		}

		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access')) {
			$this->error();
		}
	}

	/**
	 * @param mixed $id
	 */
	public function handlePdf($id): void
	{
		$invoice = $this->invoices->get((int) $id);

		if ($invoice === null) {
			$this->error();
		}

		$this->invoicePdfBuilderFactory->create($invoice)->render();
	}

	public function handleRegenerate(int $invoiceId): void
	{
		if ($this->invoices->regenerateInvoice($invoiceId)) {
			$this->flashMessageSuccess('eshopOrders.invoice.regenerated');
		} else {
			$this->flashMessageDanger('default.error');
		}

		$this->redrawControl('flashes');
	}
}
