<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use EshopOrders\AdminModule\Components\Invoice\IInvoiceConfigFormFactory;
use EshopOrders\AdminModule\Components\Invoice\IInvoiceConfigsGridFactory;
use EshopOrders\AdminModule\Components\Invoice\InvoiceConfigForm;
use EshopOrders\AdminModule\Components\Invoice\InvoiceConfigsGrid;
use EshopOrders\Model\InvoiceConfigRepository;
use Nette\Utils\ArrayHash;

class InvoiceConfigsPresenter extends BasePresenter
{
	public InvoiceConfigRepository $invoiceConfigRepository;

	public function __construct(
		InvoiceConfigRepository $invoiceConfigRepository
	)
	{
		$this->invoiceConfigRepository = $invoiceConfigRepository;
	}

	public function actionDefault(): void
	{
		$this->setHeader('eshopOrders.title.invoiceSettings', 'fas fa-cogs');

		// invoice settings navigation item
		$navigation[] = [
			'title' => 'eshopOrders.menu.addInvoiceSettings',
			'link'  => $this->link('invoiceSettings!'),
			'ico'   => 'fas fa-plus',
			'class' => 'ajax',
		];

		$this['navigation']->setData(['header' => $navigation]);
	}

	public function handleInvoiceSettings(?int $itemId = null): void
	{
		if (!$itemId && $this->invoiceConfigRepository->haveAllSellersInvoiceSettingsCreated()) {
			$this->flashMessageWarning('eshopOrders.invoiceConfigForm.numericalSeries.warnings.allSitesHaveInvoiceSettingsCreated');
			$this->redrawControl('flashes');

			return;
		}

		if ($itemId) {
			$this['invoiceConfigForm']->setDefaults();
		}

		$this->template->modalTitle = $this->t('eshopOrders.title.invoiceSettings');
		$this->redrawControl('modal');
	}

	public function createComponentInvoiceConfigForm(IInvoiceConfigFormFactory $factory): InvoiceConfigForm
	{
		$itemId = $this->getParameter('itemId');
		$form   = $factory->create($itemId ? ((int) $itemId) : null);

		$form['form']->onSuccess[] = function(BaseForm $form, ArrayHash $arrayHash) {
			$this['invoiceConfigsGrid']['grid']->reload();
		};

		return $form;
	}

	public function createComponentInvoiceConfigsGrid(IInvoiceConfigsGridFactory $factory): InvoiceConfigsGrid { return $factory->create(); }
}
