<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Product;

use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\Dao\ProductReview;
use EshopOrders\FrontModule\Model\ProductReviews as ProductReviewsService;

class ProductReviews extends BaseControl
{
	/** @var ProductReview[] */
	protected array $productReviewItems = [];

	public function __construct(
		int                   $productId,
		ProductReviewsService $productReviews
	)
	{
		$this->productReviewItems = $productReviews->getByProduct($productId);
	}

	public function render(): void
	{
		$this->template->reviews = $this->productReviewItems;
		$this->template->render($this->getTemplateFile());
	}

	public function getProductReviewsCount(): int
	{
		return count($this->productReviewItems);
	}
}
