<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use Core\Model\Application\AppState;
use EshopOrders\Model\Entities\IDiscount;

class Discount implements IDiscount
{
	public string  $id;
	public ?string $title                  = null;
	public ?float  $amount                 = null;
	public ?float  $amountInBaseCurrency   = null;
	public float   $discountInBaseCurrency = 0;
	public float   $discount               = 0;
	public string  $type;
	public string  $typeSymbol             = '';
	public ?string $packageType            = null;

	public ?string $text = null;

	/** @var callable|null */
	public $calculateDiscountCallback = null;

	public function __construct(
		string $id,
		float  $amount,
		string $type,
		string $packageType
	)
	{
		$this->id          = $id;
		$this->amount      = $amount;
		$this->type        = $type;
		$this->packageType = $packageType;
	}

	public function calculateDiscount(): float
	{
		if (is_callable($this->calculateDiscountCallback)) {
			return call_user_func($this->calculateDiscountCallback, $this);
		}

		return round($this->discount, (int) AppState::getState('eshopOrdersCartDecimals', 0));
	}

	public function getValue(): float { return $this->amount; }

	public function getType(): string { return $this->type; }
}



