<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Subscribers;

use Contributte\Events\Extra\Event\Security\LoggedInEvent;
use Contributte\Events\Extra\Event\Security\LoggedOutEvent;
use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\FrontModule\Model\CartFacade;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Tracy\Debugger;

class ApplicationSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;
	protected CartFacade             $cartFacade;

	public function __construct(
		EntityManagerDecorator $em,
		CartFacade             $cartFacade
	)
	{
		$this->em         = $em;
		$this->cartFacade = $cartFacade;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			LoggedInEvent::class  => 'loggedIn',
			LoggedOutEvent::class => 'loggedOut',
		];
	}

	public function loggedIn(LoggedInEvent $event): void
	{
		try {
			$this->cartFacade->mergeCartToUserCart($event->getUser()->getId());
		} catch (\Exception $e) {
			Debugger::log($e, Debugger::ERROR);
		}
	}

	public function loggedOut(LoggedOutEvent $event): void
	{
		$this->cartFacade->getCartsService()->unsetCart();
	}
}
