<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Affiliate;

use Core\Model\Entities\TIdUnsigned;
use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\Random;

/**
 * @ORM\Table("eshop_orders__affiliate_campaign")
 * @ORM\Entity
 */
class AffiliateCampaign
{
	use TIdUnsigned;

	/**
	 * @ORM\Column(name="name", type="string", nullable=false)
	 */
	public string $name;

	/**
	 * @ORM\Column(name="ident", type="string", nullable=true)
	 */
	public string $ident;

	/**
	 * @ORM\ManyToOne(targetEntity="AffiliatePartner", inversedBy="campaigns")
	 * @ORM\JoinColumn(name="partner_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public AffiliatePartner $partner;

	/**
	 * @ORM\Column(name="created", type="datetime", nullable=false, options={"default":"CURRENT_TIMESTAMP"})
	 */
	public DateTime $created;

	/**
	 * @var ArrayCollection<AffiliateOrder>
	 * @ORM\OneToMany(targetEntity="AffiliateOrder", mappedBy="campaign")
	 */
	public Collection $orders;

	/**
	 * @var ArrayCollection<AffiliateCampaignStat>
	 * @ORM\OneToMany(targetEntity="AffiliateCampaignStat", mappedBy="campaign")
	 */
	public Collection $stats;

	/**
	 * @ORM\Column(name="export_hash", type="string", length=12, nullable=false)
	 */
	public string $exportHash;

	/**
	 * @ORM\Column(name="commission", type="integer", nullable=false, options={"default":0})
	 */
	public int $commission = 0;

	public function __construct(string $name, string $ident, AffiliatePartner $partner)
	{
		$this->name       = $name;
		$this->ident      = $ident;
		$this->partner    = $partner;
		$this->created    = new DateTime();
		$this->orders     = new ArrayCollection();
		$this->stats      = new ArrayCollection();
		$this->exportHash = Random::generate(12);
	}
}

