<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Invoice;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_orders__invoice_address")
 * @ORM\Entity
 */
class Address
{
	use TId;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $street = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $city = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $postal = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $country = null;

	/**
	 * @ORM\Column(name="country_code", type="string", length=2, nullable=true)
	 */
	public ?string $countryCode = null;

}
