<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Invoice;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\PriceCalculator\PriceCalculatorItem;

/**
 * @ORM\Table("eshop_orders__invoice_payment")
 * @ORM\Entity
 */
class Payment
{
	use TId;

	/**
	 * @ORM\Column(type="integer", options={"unsigned": true})
	 */
	public int $paymentId;

	/**
	 * @ORM\Column(type="string")
	 */
	public ?string $name = null;

	/**
	 * @var float|string
	 * @ORM\Column(type="decimal", precision=10, scale=2)
	 */
	protected $price;

	/**
	 * @ORM\OneToOne(targetEntity="InvoiceData", mappedBy="payment")
	 */
	public InvoiceData $invoiceData;

	/**
	 * @ORM\Column(name="vat_rate", type="smallint", nullable=true)
	 */
	protected ?int $vatRate = null;

	public ?PriceCalculatorItem $priceCalculatorItem = null;

	/** @param float|string $price */
	public function setPrice($price): void { $this->price = (string) $price; }

	public function getPriceRaw(): float { return (float) $this->price; }

	public function getPrice(): float
	{
		return $this->priceCalculatorItem->getTotalWithVat()->getAmount()->toFloat();
	}

	public function getPriceWithoutVat(): float
	{
		return $this->priceCalculatorItem->getTotalWithoutVat()->getAmount()->toFloat();
	}

	public function setVatRate(int $vatRate): void { $this->vatRate = $vatRate; }

	public function getVatRate(): int { return $this->invoiceData && $this->invoiceData->zeroVat ? 0 : ($this->vatRate ?: 21); }
}
