<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities\Invoice;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_orders__invoice_supplier")
 * @ORM\Entity
 */
class Supplier
{
	use TId;

	/**
	 * @ORM\Column(name="name", type="string")
	 */
	public ?string $name = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $idNumber = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $vatNumber = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $email = null;

	/**
	 * @ORM\OneToOne(targetEntity="Bank", cascade={"persist"})
	 * @ORM\JoinColumn(name="bank_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	public ?Bank $bank = null;

	/**
	 * @var bool
	 * @ORM\Column(type="boolean", options={"default": false})
	 */
	public $isPayerVat = false;

	/**
	 * @ORM\OneToOne(targetEntity="Address", cascade={"persist"})
	 * @ORM\JoinColumn(name="address_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	public ?Address $address = null;

	public function __construct(Bank $bank, Address $address)
	{
		$this->bank    = $bank;
		$this->address = $address;
	}

	public function getBank(): Bank { return $this->bank; }

	public function getAddress(): Address { return $this->address; }
}
