<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_orders__invoice_config")
 * @ORM\Entity
 */
class InvoiceConfig
{
	use TId;

	public const TYPE_INVOICE          = 'invoice';
	public const TYPE_INVOICE_EXTERNAL = 'invoiceExternal';
	public const TYPE_CORRECTIVE       = 'corrective';
	public const TYPE_RECEIPT          = 'receipt';

	/**
	 * @ORM\Column(type="integer", nullable=false)
	 */
	public int $maturity;

	/**
	 * @ORM\OneToOne(targetEntity="NumericalSeries", cascade={"all"})
	 * @ORM\JoinColumn(name="numerical_series_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public NumericalSeries $numericalSeries;

	/**
	 * @ORM\OneToOne(targetEntity="NumericalSeries", cascade={"all"})
	 * @ORM\JoinColumn(name="corrective_tax_numerical_series_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public NumericalSeries $correctiveNumericalSeries;

	/**
	 * @ORM\OneToOne(targetEntity="NumericalSeries", cascade={"all"})
	 * @ORM\JoinColumn(name="receipt_numerical_series_id", referencedColumnName="id", nullable=true, onDelete="CASCADE")
	 */
	public ?NumericalSeries $receiptNumericalSeries = null;

	/**
	 * @var ArrayCollection|SellerInvoiceConfig[]
	 * @ORM\OneToMany(targetEntity="SellerInvoiceConfig", mappedBy="invoiceConfig", cascade={"all"})
	 */
	public $sellerInvoiceConfigs;

	public function __construct(
		int              $maturity,
		NumericalSeries  $numericalSeries,
		NumericalSeries  $correctiveNumericalSeries,
		?NumericalSeries $receiptNumericalSeries = null
	)
	{
		$this->maturity                  = $maturity;
		$this->numericalSeries           = $numericalSeries;
		$this->correctiveNumericalSeries = $correctiveNumericalSeries;
		$this->receiptNumericalSeries    = $receiptNumericalSeries;
		$this->sellerInvoiceConfigs      = new ArrayCollection;
	}

}
