<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;
use Users\Model\Entities\User;

/**
 * @ORM\Table("eshop_orders__order_expedition_log")
 * @ORM\Entity
 */
class OrderExpeditionLog
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Order $order;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $service;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $status;

	/**
	 * @ORM\Column(type="text", nullable=false)
	 */
	public string $message;

	/**
	 * @ORM\Column(name="created", type="datetime", options={"default": "CURRENT_TIMESTAMP"})
	 */
	protected \DateTime $created;

	/**
	 * @ORM\ManyToOne(targetEntity="\Users\Model\Entities\User")
	 * @ORM\JoinColumn(name="created_by", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected ?User $createdBy = null;

	public function __construct(Order $order, string $service, string $status, string $message, ?User $createdBy = null)
	{
		$this->order     = $order;
		$this->service   = $service;
		$this->status    = $status;
		$this->message   = $message;
		$this->createdBy = $createdBy;
		$this->created   = new DateTime;
	}

	public function getOrder(): Order { return $this->order; }

	public function getCreated(): \DateTime { return $this->created; }

	public function getCreatedBy(): ?User { return $this->createdBy; }
}
