<?php declare(strict_types = 1);

namespace EshopOrders\Model\PriceCalculator;

use Brick\Math\RoundingMode;
use Brick\Money\Money;
use InvalidArgumentException;

class PriceCalculatorDiscount
{
	protected string $type;
	protected Money  $value;

	public function __construct(string $type, float $value, string $currency)
	{
		if (!in_array($type, ['fix', 'percent'])) {
			throw new InvalidArgumentException("Invalid discount type: $type");
		}

		$this->type  = $type;
		$this->value = Money::of($value, $currency, null, RoundingMode::HALF_UP);
	}

	public function getType(): string
	{
		return $this->type;
	}

	public function getValue(): Money
	{
		return $this->value;
	}
}
