<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20210701070617 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE eshop_orders__spedition ADD vat_rate INT DEFAULT NULL');
		$this->addSql('ALTER TABLE eshop_orders__spedition ADD CONSTRAINT FK_641A1083F684F7C7 FOREIGN KEY (vat_rate) REFERENCES eshop_catalog__vat_rate (id) ON DELETE SET NULL');
		$this->addSql('CREATE INDEX IDX_641A1083F684F7C7 ON eshop_orders__spedition (vat_rate)');
		$this->addSql('ALTER TABLE eshop_orders__order_payment ADD vat_rate SMALLINT DEFAULT NULL');
		$this->addSql('ALTER TABLE eshop_orders__order_spedition ADD vat_rate SMALLINT DEFAULT NULL');
		$this->addSql('ALTER TABLE eshop_orders__invoice_payment ADD vat_rate SMALLINT DEFAULT NULL');
		$this->addSql('ALTER TABLE eshop_orders__invoice_spedition ADD vat_rate SMALLINT DEFAULT NULL');
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$id = $this->connection->fetchOne('SELECT id FROM eshop_catalog__vat_rate WHERE `rate` = 21');
		if ($id) {
			$this->connection->update('eshop_orders__spedition', [
				'vat_rate' => $id,
			], [
				'vat_rate' => null,
			]);
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE eshop_orders__order_payment DROP vat_rate');
		$this->addSql('ALTER TABLE eshop_orders__order_spedition DROP vat_rate');
		$this->addSql('ALTER TABLE eshop_orders__invoice_spedition DROP vat_rate');
		$this->addSql('ALTER TABLE eshop_orders__invoice_payment DROP vat_rate');
		$this->addSql('ALTER TABLE eshop_orders__spedition DROP FOREIGN KEY FK_641A1083F684F7C7');
		$this->addSql('DROP INDEX IDX_641A1083F684F7C7 ON eshop_orders__spedition');
		$this->addSql('ALTER TABLE eshop_orders__spedition DROP vat_rate');
	}
}
