<?php declare(strict_types=1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use EshopOrders\Model\Orders;

class OrderMessageModal extends BaseControl
{
	protected Orders $orders;
	protected ?string $message = null;

	public function __construct(Orders $orders)
	{
		$this->orders = $orders;
	}

	public function render(): void
	{
		$this->template->message = $this->message;
		$this->template->render($this->getTemplateFile());
	}

	public function setOrder(int $orderId): void
	{
		$order = $this->orders->get($orderId);
		$this->message = $order ? $order->getMessage() : null;
	}

}