<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Module;
use Doctrine\ORM\Query\Expr\Join;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderStatus;
use EshopOrders\Model\Entities\Status;
use Contributte\Translation\Translator;
use Users\Model\Http\UserStorage;
use EshopOrders\Model\Statuses as PublicStatuses;

/**
 * @method Status|object|null getReference($id)
 * @method Status[]|null getAll()
 * @method Status|null get($id)
 */
class Statuses extends BaseEntityService
{
	protected $entityClass = Status::class;

	protected UserStorage    $userStorage;
	protected Translator     $translator;
	protected PublicStatuses $publicStatuses;

	protected ?array $cOptionsFormSelect = null;

	public function __construct(
		UserStorage    $userStorage,
		Translator     $translator,
		PublicStatuses $statuses
	)
	{
		$this->userStorage    = $userStorage;
		$this->translator     = $translator;
		$this->publicStatuses = $statuses;
	}

	public function changeStatus(array $ids, string $status): bool
	{
		return $this->publicStatuses->changeStatus($ids, $status);
	}

	public function getForSelectOption(): array
	{
		if (Module::isFront()) {
			return [];
		}

		if ($this->cOptionsFormSelect === null) {
			$this->cOptionsFormSelect = [];

			foreach ($this->getEr()->createQueryBuilder('s')
				         ->select('s.id, st.name')
				         ->innerJoin('s.texts', 'st', Join::WITH, 'st.lang = :lang')
				         ->setParameter('lang', $this->translator->getLocale())
				         ->orderBy('s.position', 'ASC')
				         ->getQuery()->getArrayResult() as $row) {
				$this->cOptionsFormSelect[$row['id']] = $row['name'];
			}
		}

		return $this->cOptionsFormSelect;
	}

	public function sendOrderStatusEmail(Order $order, OrderStatus $orderStatus): void
	{
		$this->publicStatuses->sendOrderStatusEmail($order, $orderStatus);
	}

	public function changeSendToClient(string $id, int $value): bool
	{
		try {
			$status = $this->get($id);

			if (!$status) {
				return false;
			}

			$status->sendToCustomer = $value;
			$this->em->persist($status);
			$this->em->flush();

			return true;
		} catch (\Exception $e) {
		}

		return false;
	}
}
