<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\BodyEntity;

use Apitte\Core\Mapping\Request\BasicEntity;

class Customer extends BasicEntity
{
	public ?int $id = null;
	public ?bool $isActive = null;
	public ?int $group = null;
	public ?string $firstName = null;
	public ?string $lastName = null;
	public ?string $phone = null;
	public ?string $email = null;
	public ?int $parentCustomer = null;
	public array $canManageUsers = [];
	public ?array $disablePayments = null;
	public ?array $disableSpeditions = null;
	public ?float $minimalOrderPrice = null;
	public ?bool $allowOrderPrice = null;
	public ?bool $showPricesWithoutVat = null;
	public ?Address $addressDelivery = null;
	public ?Address $addressInvoice = null;

	protected function normalize(string $property, $value)
	{
		if ($property === 'addressDelivery') {
			$this->addressDelivery ??= new Address;
			return $this->addressDelivery->factory($value);
		}

		if ($property === 'addressInvoice') {
			$this->addressDelivery ??= new Address;
			return $this->addressDelivery->factory($value);
		}

		return parent::normalize($property, $value);
	}

}