<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Apitte\Negotiation\Http\ArrayEntity;
use EshopOrders\ApiModule\Api\V1\Model\PaymentSpeditions;

/**
 * @Path("/payment-speditions")
 */
class PaymentSpeditionsController extends BaseController
{
	protected PaymentSpeditions $paymentSpeditions;

	public function __construct(PaymentSpeditions $paymentSpeditions)
	{
		$this->paymentSpeditions = $paymentSpeditions;
	}

	/**
	 * @Path("/")
	 * @Method("GET")
	 */
	public function index(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from($this->paymentSpeditions->getAll()));
	}

	/**
	 * @Path("/countries")
	 * @Method("GET")
	 */
	public function getCountries(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from($this->paymentSpeditions->getCountries()));
	}

}