<?php declare(strict_types = 1);

namespace EshopOrders\Console\Stats;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use EshopOrders\AdminModule\Model\Carts;
use EshopOrders\AdminModule\Model\Statistics\Statistics;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class GenerateMonthly extends AbstractCommand
{
	/** @var Statistics|null @inject */
	public ?Statistics $statistics = null;

	protected function configure()
	{
		$this->setName('eshoporders:stats:generate-monthly')->setDescription('');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('GENERATE MONTHLY STATS');

		try {
			$this->statistics->getMonthly(false);

			$output->writeLn('<info>[OK] - generated</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 0;
	}
}
