<?php declare(strict_types = 1);

namespace EshopOrders\CronModule\Presenters;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Query\Expr\Join;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderStatus;
use EshopOrders\Model\EshopOrdersConfig;
use Nette\Security\Passwords;
use Nette\Utils\DateTime;

class CustomersPresenter extends BasePresenter
{
	protected EntityManagerDecorator $em;

	public function __construct(
		EntityManagerDecorator $em
	)
	{
		$this->em = $em;
	}

	public function actionFilterByOrders(
		string $key,
		string $siteIdent,
		string $from,
		string $to
	): void
	{
		$fromDate = DateTime::createFromFormat('Y-m-d', $from)->setTime(0, 0, 0);
		$toDate   = DateTime::createFromFormat('Y-m-d', $to)->setTime(23, 59, 59);

		$password  = new Passwords();
		$keyVerify = $password->verify(EshopOrdersConfig::load('cronUrlHash') . $siteIdent, $key);

		if (!$keyVerify) {
			$this->error();
		}

		header('Content-Encoding: UTF-8');
		header("content-type:application/csv;charset=UTF-8");
		header("Content-Disposition:attachment;filename=\"uzivatele.csv\"");
		header('Content-Transfer-Encoding: binary');

		$fp = fopen('php://output', 'wb');
		fputs($fp, "\xEF\xBB\xBF");

		foreach ($this->em->getRepository(Order::class)->createQueryBuilder('o')
			         ->select('o.id, inv.firstName, inv.lastName, inv.email')
			         ->innerJoin('o.orderStatuses', 'os', Join::WITH, 'os.status = :status AND os.created >= :from AND os.created <= :to')
			         ->innerJoin('o.addressInvoice', 'inv')
			         ->where('o.site = :siteIdent')
			         ->setParameters([
				         'siteIdent' => $siteIdent,
				         'status'    => OrderStatus::STATUS_CREATED,
				         'from'      => $from,
				         'to'        => $to,
			         ])->groupBy('inv.email')
			         ->orderBy('o.id', 'ASC')
			         ->getQuery()->getArrayResult() as $row) {
			fputcsv($fp, [
				$row['firstName'],
				$row['lastName'],
				$row['email'],
			], ';');
		}

		fclose($fp);

		exit;
	}
}
