<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Event;

use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderAddress;
use EshopOrders\Model\Entities\OrderItem;
use EshopOrders\Model\Entities\OrderPayment;
use EshopOrders\Model\Entities\OrderSpedition;
use Nette\Utils\ArrayHash;
use Symfony\Contracts\EventDispatcher\Event;

class OrderEvent extends Event
{
	/** @var Order|null */
	public $order;

	/** @var OrderAddress|null */
	public $addrDelivery;

	/** @var OrderAddress|null */
	public $addrInvoice;

	/** @var OrderSpedition|null */
	public $orderSpedition;

	/** @var OrderPayment|null */
	public $orderPayment = null;

	/** @var OrderItem[] */
	public $orderItems = [];

	/** @var array|ArrayHash */
	public $formData = [];

	public function __construct(Order &$order)
	{
		$this->order = &$order;
	}
}
