<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_orders__order_currency")
 * @ORM\Entity
 */
class OrderCurrency
{

	/**
	 * @var Order
	 * @ORM\Id
	 * @ORM\OneToOne(targetEntity="Order", inversedBy="currency")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $order;

	/**
	 * @var string
	 * @ORM\Column(name="code", type="string", length=3, nullable=false, options={"default": "CZK"})
	 */
	public $code;

	/**
	 * @var float
	 * @ORM\Column(name="rate", type="decimal", precision=10, scale=5, nullable=false, options={"default": 1})
	 */
	public $rate;

	/**
	 * @var int
	 * @ORM\Column(name="decimals", type="integer", nullable=false, options={"default": 0})
	 */
	public $decimals;

	public function __construct(Order $order, string $code)
	{
		$this->order    = $order;
		$this->code     = $code;
		$this->rate     = 1;
		$this->decimals = 0;
	}

	public function getOrder(): Order
	{
		return $this->order;
	}
}
