<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_orders__status_text")
 * @ORM\Entity
 */
class StatusText
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Status", inversedBy="texts")
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Status $status;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2)
	 */
	protected string $lang;

	/**
	 * @ORM\Column(name="name", type="string", length=255, nullable=true)
	 */
	public ?string $name = null;

	public function __construct(
		Status $status,
		string $lang
	)
	{
		$this->status = $status;
		$this->lang   = $lang;
	}

	public function getStatus(): Status { return $this->status; }

	public function getLang(): string { return $this->lang; }
}
