<?php declare(strict_types = 1);

namespace EshopOrders\Model\Helpers;

use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\Model\Entities\Order;

class OrderSpeditionHelper
{
	protected EntityManagerDecorator $em;

	public function __construct(
		EntityManagerDecorator $em
	)
	{
		$this->em = $em;
	}

	public function checkSpeditionVatRateByItemsPrice(Order $order): void
	{
		$maxPriceRate = null;
		$maxPrice     = 0;

		foreach ($order->getVatRates() as $rate => $prices) {
			if ($prices['total'] > $maxPrice) {
				$maxPrice     = $prices['total'];
				$maxPriceRate = $rate;
			}
		}

		if ($order->getSpedition()) {
			$order->getSpedition()->setVatRate($maxPriceRate);
			$this->em->persist($order->getSpedition());
		}

		if ($order->getPayment()) {
			$order->getPayment()->setVatRate($maxPriceRate);
			$this->em->persist($order->getPayment());
		}

		$this->em->flush();
	}
}
