<?php declare(strict_types = 1);

namespace EshopOrders\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use EshopOrders\Model\Orders;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class Customer extends BaseNavigation implements INavigationItem
{
	protected $title             = 'customerOrders';
	protected $presenter         = 'EshopOrders:Front:Customer';
	protected $action            = 'default';
	protected $actionOrderDetail = 'orderDetail';
	protected $actionEditProfile = 'editProfile';
	protected $actionMyProducts  = 'myProducts';

	protected const URL_EDIT        = 'edit';
	protected const URL_MY_PRODUCTS = 'my-products';

	/** @var Orders */
	protected $orders;

	public function __construct(Orders $orders)
	{
		$this->orders = $orders;
	}

	/**
	 * @param BaseForm $baseForm
	 *
	 * @return BaseContainer
	 */
	public function getFormContainer(BaseForm $baseForm)
	{
		$container = new BaseContainer();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{

	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action)
			return 1;
		if ($this->presenter == $presenter && $this->actionOrderDetail == $action)
			return 2;
		if ($this->presenter == $presenter && $this->actionEditProfile == $action)
			return 3;
		if ($this->presenter == $presenter && $this->actionMyProducts == $action)
			return 4;

		return false;
	}

	public function routerIn($navigation, $urlParams = [])
	{
		if (isset($urlParams['path'])) {

			$params      = explode('/', $urlParams['path']);
			$lastSegment = array_pop($params);
			$id          = explode('-', $lastSegment, 2);

			if (is_numeric($id[0])) {
				//ID objednavky - detail
				return [
					'presenter' => $this->presenter,
					'action'    => $this->actionOrderDetail,
					'id'        => $id[0],
				];
			} elseif ($lastSegment == self::URL_EDIT) {
				return [
					'presenter' => $this->presenter,
					'action'    => $this->actionEditProfile,
					'id'        => null,
				];
			} elseif ($lastSegment == self::URL_MY_PRODUCTS) {
				return [
					'presenter' => $this->presenter,
					'action'    => $this->actionMyProducts,
					'id'        => null,
				];
			}
		}

		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams = []): ?string
	{
		$urlParts = [];
		if (!$navigation->isHomepage)
			$urlParts[] = $navigation->alias;

		if (isset($urlParams['orderId'])) {
			$order = $this->orders->get($urlParams['orderId']);
			if ($order)
				$urlParts[] = $order->getId() . '-objednavka';
		} elseif ($urlParams['action'] == $this->actionEditProfile) {
			$urlParts[] = self::URL_EDIT;
		} elseif ($urlParams['action'] == $this->actionMyProducts) {
			$urlParts[] = self::URL_MY_PRODUCTS;
		}

		return '/' . implode('/', $urlParts);
	}

}
