<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use EshopCatalog\Model\Entities\Product;
use EshopOrders\Model\Entities\OrderItem;
use EshopOrders\Model\Orders;
use EshopOrders\Model\OrderItems;
use Gallery\Model\Entities\Image;
use Nette\Utils\Html;
use Tracy\Debugger;

class OrderItemsGrid extends BaseControl
{
	/** @var Orders */
	protected $ordersService;

	/** var OrderItems */
	protected $orderItemsService;

	private $orderId;

	public function __construct($orderId, Orders $orders, OrderItems $orderItems)
	{
		$this->orderId           = $orderId;
		$this->ordersService     = $orders;
		$this->orderItemsService = $orderItems;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		$qb   = $this->orderItemsService->getEr()->createQueryBuilder('oi')
			->andWhere('oi.order = :order')->setParameter('order', $this->orderId)
			->orderBy('oi.id', 'ASC');

		/*$qb = $this->orderItemsService->getEr()->createQueryBuilder('oi')
			->addSelect('oi.id, p, gal, imgs')
			->leftJoin('EshopCatalog\Model\Entities\Product', 'p', 'WITH', 'oi.productId = p.id')
			->leftJoin('p.gallery', 'gal')
			->leftJoin('gal.images', 'imgs', 'WITH', 'imgs.isCover = 1 OR imgs.position = 0')
			->andWhere('oi.order = :order')->setParameter('order', $this->ordersService->getReference($this->orderId))
			->orderBy('oi.id', 'ASC');*/

		$prodIds = $this->orderItemsService->getEr()->createQueryBuilder('oi')
			->select('oi.productId')
			->andWhere('oi.order = :order')->setParameter('order', $this->orderId)
			->getQuery()->getResult();
		$prodIds = array_map(function($v) { return $v['productId']; }, $prodIds);


		$images = $this->em->getRepository(Product::class)->createQueryBuilder('p', 'p.id')
			->select('p, gal, imgs')//jen nejnutnejsi info - p.id, gal.basePath, img name
			->leftJoin('p.gallery', 'gal')
			->leftJoin('gal.images', 'imgs', 'WITH', 'imgs.isCover = 1 OR imgs.position = 0')
			->andWhere('p.id IN (:ids)')->setParameter('ids', $prodIds)
			->groupBy('p.id')
			->getQuery()->getResult();

		/*$images = $this->em->getRepository(Image::class)->createQueryBuilder('imgs', 'p.id')
			->select(' imgs, gal.basePath, gal.id AS galleryId, p.id AS productId') //jen nejnutnejsi info - p.id, gal.basePath, img name
			->leftJoin('Gallery\Model\Entities\Album', 'gal', 'WITH', 'imgs.album = gal.id AND (imgs.isCover = 1 OR imgs.position = 0)')
			->leftJoin('EshopCatalog\Model\Entities\Product', 'p', 'WITH', 'p.gallery = gal.id')
			->andWhere('p.id IN (:ids)')->setParameter('ids', $prodIds)
			->groupBy('p.id')
			->getQuery()->getResult();*/

		$grid->setDataSource($qb);

		//Columns
		$grid->addColumnText('image', 'eshopOrders.defaultGrid.image', '')
			->setRenderer(function($row) use ($images) {
				if (!array_key_exists($row->getProductId(), $images) || !$images[$row->getProductId()]->gallery->images) {
					return '';
				}
				$image = $images[$row->getProductId()]->gallery->images->first();

				return Html::el('')
					->addHtml(Html::el('img', [
						'onMouseOver' => "showPicture('spt-{$row->getId()}', 1)",
						'onMouseOut'  => "showPicture('spt-{$row->getId()}', 0)",
						'src'         => $this->imagePipe->request($image->getFilePath(), '50x40'),
					]))
					->addHtml(Html::el('img', [
						'id'    => 'spt-' . $row->getId(),
						'class' => 'show-picture-target',
						'src'   => $this->imagePipe->request($image->getFilePath(), '400x400'),
					]));
			})->setAlign('center');
		$grid->addColumnText('productName', 'eshopOrders.itemsGrid.productName')
			->setRenderer(function($row) {
				return Html::el('a',
					[
						'href'   => $this->getPresenter()->link(':EshopCatalog:Admin:Products:edit', [$row->getProductId()]),
						'target' => '_blanc',
					]
				)->setText($row->getOrderItemText($this->translator->getLocale())->getName());
			});
		/*$grid->addColumnText('variantName', 'eshopOrders.itemsGrid.variantName')
			->setRenderer(function($row) {
				return $row->getOrderItemText($this->translator->getLocale())->getVariantName();
			});*/
		$grid->addColumnText('code1', 'eshopOrders.itemsGrid.code1');
		$grid->addColumnText('quantity', 'eshopOrders.itemsGrid.quantity');
		$grid->addColumnNumber('vatRate', 'eshopOrders.itemsGrid.vatRate')->setFormat(0, ",", " ");
		$grid->addColumnNumber('price', 'eshopOrders.itemsGrid.price')->setFormat(2, ",", " ");
		$grid->addColumnNumber('priceTotal', 'eshopOrders.itemsGrid.priceTotal')->setFormat(2, ",", " ");

		// Filter

		// Actions
		$grid->addAction('front', '', ':EshopCatalog:Front:Default:product', ['id' => 'productId'])
			->setOpenInNewTab()
			->setIcon('link')->setBsType('secondary');
		$grid->addAction('edit', '', 'orderItemForm!', ['itemId' => 'id'])
			->addClass('ajax')
			->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'orderItemForm:delete!', ['itemId' => 'id'])
			->addClass('ajax')
			->setIcon('times')->setBsType('danger')
			->setConfirm('eshopOrders.itemsGrid.deleteConfirm');

		$grid->setColumnsSummary(['priceTotal']);

		// Columns prototype

		return $grid;
	}

	public function setOrder($id)
	{
		$this->orderId = $id;
	}


	/*******************************************************************************************************************
	 * ==================  Handle
	 */


	/*******************************************************************************************************************
	 * =================  Grid function
	 */

}
