<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use EshopOrders\Model\Orders;
use EshopOrders\Model\OrderStatuses;

class OrderStatusesGrid extends BaseControl
{
	/** @var Orders */
	protected $ordersService;
	
	/** var OrderStatuses */
	protected $orderStatusesService;
	
	private $orderId;
	
	public function __construct(Orders $orders, OrderStatuses $orderStatuses)
	{
		$this->ordersService     = $orders;
		$this->orderStatusesService = $orderStatuses;
	}
	
	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}
	
	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		$qb = $this->orderStatusesService->getEr()->createQueryBuilder('os')
				->andWhere('os.order = :order')->setParameter('order', $this->ordersService->getReference($this->orderId))
				->orderBy('os.id', 'ASC');
		$grid->setDataSource($qb);
		
		//Columns
		$grid->addColumnText('statusName', 'eshopOrders.statusesGrid.statusName', 'status.name');
		$grid->addColumnDateTime('statusTime', 'eshopOrders.statusesGrid.statusTime', 'created')->setFormat('d.m.Y H:i');
		
		// Filter;
		
		// Columns prototype
		
		return $grid;
	}
	
	public function setOrder($id)
	{
		$this->orderId = $id;
	}
	

	/*******************************************************************************************************************
	 * ==================  Handle
	 */
	

	/*******************************************************************************************************************
	 * =================  Grid function
	 */
	
}
