<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Customer;

use Nette\Forms\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Core\Model\UI\BaseControl;
use Doctrine\Common\Collections\ArrayCollection;
use EshopOrders\Model\Entities\Customer;
use EshopOrders\Model\Entities\CustomerAddress;
use Users\Model\Entities\User;

class ProfileForm extends BaseControl
{
	/** @var User */
	public $user;

	/** @var Customer */
	public $customer;

	public function render()
	{
		if (!$this->user)
			return '';

		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('name', 'default.name');
		$form->addText('lastname', 'default.lastName')->setRequired();
		$form->addPassword('password', 'default.password');
		$form->addEmail('email', 'default.email')->setRequired();
		$form->addText('phone', 'default.phone');
		$form->addText('company', 'eshopOrders.orderPage.company');
		$form->addText('street', 'default.street');
		$form->addText('city', 'default.city');
		$form->addText('postal', 'default.zipNumber');

		$form->addSubmit('submit', 'default.save');
		$form->addCancel('cancel', 'default.cancel');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values)
	{
		try {
			$user     = $this->user;
			$customer = $this->customer;
			$address  = $customer->getAddressDelivery();

			$user->setName($values->name);
			$user->setLastname($values->lastname);
			$user->setEmail($values->email);

			$customer->setPhone($values->phone);
			
			if(!$address) {
				$address = new CustomerAddress($customer);
			}
			$address->setCompany($values->company);
			$address->setStreet($values->street);
			$address->setCity($values->city);
			$address->setPostal($values->postal);
			$customer->setAddressDelivery($address);

			if ($values->password != '')
				$user->setPassword($values->password);

			$this->em->persist($user);
			$this->em->persist($customer);
			$this->em->persist($address);
			$this->em->flush();
			$this->getPresenter()->flashMessageSuccess('users.profileForm.profileUpdated');
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setUser($user, $customer)
	{
		$this->user     = $user;
		$this->customer = $customer;

		if ($this->user && $this->customer) {
			$defaults = [
				'name'     => $this->user->getName(),
				'lastname' => $this->user->getLastname(),
				'email'    => $this->user->getEmail(),
				'phone'    => $this->customer->getPhone(),
			];
			if($address = $this->customer->getAddressDelivery()) {
				$defaults['company'] = $address->getCompany();
				$defaults['street'] = $address->getStreet();
				$defaults['city'] = $address->getCity();
				$defaults['postal'] = $address->getPostal();
			}
			
			$this['form']->setDefaults($defaults);

			$this['form']['password']->setRequired(false);
		} else {
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
		}
	}
}

