<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use EshopOrders\Model\Entities\OrderFlag;
use Nette\Http\Session;
use Soukicz\Zbozicz;

class OrderZboziSubscriber implements EventSubscriber
{
	/** @var  array */
	protected $zboziConf;

	/** @var SessionSection */
	protected $orderSuccessMessages;

	public function __construct(array $conf, Session $session)
	{
		$this->zboziConf            = $data['zboziCzConfig'];
		$this->orderSuccessMessages = $session->getSection('eshopOrders/orderSuccessMessages');
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess' => ['orderOnSuccess', 101],
		];
	}

	public function orderOnSuccess(OrderEvent $event): void
	{
		$conf = $this->zboziConf;
		$order = $event->order;
		if (!$order->hasFlag(OrderFlag::TYPE_QUESTIONING) || !$conf['shopId'] || $conf['privateKey'])
			return;

		$client = new Zbozicz\Client($conf['shopId'], $conf['privateKey'], $conf['isSandbox']);

		//radeji pouzijeme kod, ale pokud neni, tak alespon ID
		$spedition = $order->getSpedition();
		$spedId    = $spedition->getSpedition()->getZboziId();
		if (!$spedId)
			$spedId = $spedition->getSpedition()->getId();

		$payment = $order->getPayment();
		$payId   = $payment->getPayment()->getIdent();
		if (!$payId)
			$payId = $payment->getPayment()->getId();

		$zboziOrder = new Zbozicz\Order($order->getId());
		$zboziOrder
			->setEmail($order->getAddressDelivery()->getEmail())
			->setDeliveryType($spedId)
			->setDeliveryPrice($spedition->getPrice())
			->setPaymentType($payId);

		$otherCosts = 0;
		$otherCosts += $payment->getPrice();
		if ($order->getOrderDiscounts()) {
			foreach ($order->getOrderDiscounts() as $orderDiscount) {
				$otherCosts += $orderDiscount->getPrice();
			}
		}
		$zboziOrder->setOtherCosts($otherCosts);

		foreach ($order->getOrderItems() as $orderItem) {
			$zboziOrder->addCartItem((new Zbozicz\CartItem)
				->setId($orderItem->getProductId())
				->setName($orderItem->getOrderItemText('cs')->getName())//TODO lang
				->setUnitPrice($orderItem->getPrice())
				->setQuantity($orderItem->getQuantity())
			);
		}

		$client->sendOrder($zboziOrder);
	}
}
