<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use Core\Model\Helpers\BaseService;
use Nette\SmartObject;
use Nette\Http\Session;
use Nette\Http\SessionSection;

/**
 * class TrackingHelper
 * @package EshopOrders\FrontModule\Model
 *
 */
class TrackingHelper extends BaseService
{
	use SmartObject;

	/** @var SessionSection */
	protected $sessionSection;

	public function __construct(Session $session)
	{
		$this->sessionSection = $session->getSection('eshopOrdersOrderForm');
	}
	
	/** Zkontroluje, jestli konkretni merici kod uz byl odeslan
	 * @param $type typ konverze, napr Heureka, Zbozi, GA
	 * @return bool
	 */
	public function canSend($type)
	{
		if(empty($this->sessionSection->conversionSent[$type])) {
			return true;
		} else {
			return false;
		}
	}
	
	/** Nastavi do session priznak, ze tento konkretni konverzni kod uz byl odeslan.
	 * @param $type typ konverze, napr Heureka, Zbozi, GA
	 */
	public function send($type)
	{
		$this->sessionSection->conversionSent[$type] = true;
	}
}

