<?php declare(strict_types=1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/** podobne jako order_item, ale samostatna tabulka
 * @ORM\Table("eshop_orders__order_spedition")
 * @ORM\Entity
 */
class OrderSpedition
{
	use Identifier;
	use MagicAccessors;
	
	/**
	 * @var Spedition
	 * @ORM\ManyToOne(targetEntity="Spedition")
	 * @ORM\JoinColumn(name="spedition_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	public $spedition;
	
	/**
	 * @var string
	 * @ORM\Column(name="name", type="string")
	 */
	protected $name;
	
	/**
	 * @var int
	 * @ORM\Column(name="price", type="smallint")
	 */
	protected $price;
	
	/**
	 * @var Order
	 * @ORM\OneToOne(targetEntity="Order", inversedBy="spedition")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $order;
	
	public function __construct(Spedition $spedition, Order $order)
	{
		$this->spedition = $spedition;
		$this->name      = $spedition->getName();
		$this->price     = $spedition->getPrice();
		$this->order     = $order;
	}
	
	/**
	 * @return Spedition|null
	 */
	public function getSpedition()
	{
		return $this->spedition;
	}
	
	/**
	 * @param Spedition $spedition
	 * @return OrderSpedition
	 */
	public function setSpedition(Spedition $spedition): OrderSpedition
	{
		$this->spedition = $spedition;
		return $this;
	}
	
	/**
	 * @return string
	 */
	public function getName(): string
	{
		return $this->name;
	}
	
	/**
	 * @param string $name
	 * @return OrderSpedition
	 */
	public function setName(string $name): OrderSpedition
	{
		$this->name = $name;
		return $this;
	}
	
	/**
	 * @return int
	 */
	public function getPrice(): int
	{
		return $this->price;
	}
	
	/**
	 * @param int $price
	 * @return OrderSpedition
	 */
	public function setPrice(int $price): OrderSpedition
	{
		$this->price = $price;
		return $this;
	}
	
	/**
	 * @return Order
	 */
	public function getOrder(): Order
	{
		return $this->order;
	}
}
