import naja from 'naja';

export class AddToCartExtension {
	constructor(naja) {
		this.initButtons();
		this.initCart();

		naja.addEventListener('success', (e) => {
			this.initButtons();
			this.initCart();

			let el = document.activeElement;

			if (el.dataset.inCartText) {
				let originText = el.innerHTML;
				el.innerHTML = el.dataset.inCartText;
				el.classList.add('added');

				setTimeout(function () {
					el.innerHTML = originText;
					el.classList.remove('added');
				}, 5000);
			}
		});
	}

	// Změna počtu kusů v komponentě AddToCart
	initButtons() {
		document.querySelectorAll('[data-add-to-cart-quantity-wrap]:not(.init)').forEach((el) => {
			el.classList.add('init');
			let input = el.querySelector('[data-add-to-cart-quantity-input]');

			input.addEventListener('keypress', (e) => {
				if (e.which == 13) {
					e.preventDefault();
					e.stopImmediatePropagation();

					return false;
				}
			});

			let plus = el.querySelector('[data-add-to-cart-quantity-plus]');
			if (plus)
				plus.addEventListener('click', function (e) {
					let value = parseInt(input.value);
					let max = input.dataset.max ? parseInt(input.dataset.max) : 999999;

					if (value < max) {
						input.value = value + 1;
						input.dispatchEvent(new Event('change'));
					}
				});

			let minus = el.querySelector('[data-add-to-cart-quantity-minus]');
			if (minus)
				minus.addEventListener('click', function (e) {
					let value = parseInt(input.value);
					let min = input.dataset.allowZero === 'true' ? 0 : 1;
					if (value > min) {
						input.value = value - 1;
						input.dispatchEvent(new Event('change'));
					}
				});
		});
	}

	// Odeslání změny quantity inputu v AddToCart a v košíku
	initCart() {
		document.querySelectorAll('[data-add-to-cart-quantity-input="instant"]:not(.init)').forEach((el) => {
			el.classList.add('init');
			el.addEventListener('change', e => {
				let form = e.target.form;
				naja.makeRequest('post', form.action, new FormData(form), {
					history: false,
				});
			});
		});
	}
}
