<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use Core\Model\Helpers\BaseService;
use EshopOrders\Model\Entities\OrderDiscount;
use EshopSales\FrontModule\Model\CartSales;
use Exception;
use Nette\SmartObject;

/**
 * Class CartHelper
 * @package EshopOrders\FrontModule\Model
 */
class CartHelper extends BaseService
{
	use SmartObject;
	/**
	 * @var Carts
	 */
	protected $cartsService;
	/**
	 * @var Speditions
	 */
	protected $speditionsService;

	/** @var CartSales */
	protected $cartSales;

	public function __construct(CartSales $cartSales, Carts $carts, Speditions $speditions)
	{
		$this->cartsService      = $carts;
		$this->speditionsService = $speditions;
		$this->cartSales = $cartSales;
	}

	// --------------- Doprava zdarma ------------

	public function countFreeSpedition()
	{
		$freeSpeditionPrice = $remainingPrice = null;

		$firstFreeSpedition = $this->speditionsService->getFirstFreeSpedition();
		if ($firstFreeSpedition) {
			$freeSpeditionPrice = $firstFreeSpedition->getFreeFrom();

			$cart      = $this->cartsService->getCurrentCart();
			$cartPrice = $cart->getCartItemsPrice();

			if ($cartPrice > $freeSpeditionPrice) {
				$remainingPrice = 0;
			} else {
				$remainingPrice = $freeSpeditionPrice - $cartPrice;
			}
		}

		$cart = $this->cartsService->getCurrentCart();
		foreach ($cart->getCartItems() as $item) {
			if ($item->freeDelivery === true) {
				$freeSpeditionPrice = $item->price; //ne 0 -> to by znamenalo ze neni zdarma nikdy
				$remainingPrice     = 0;
				break;
			}
		}

		return ['minPrice' => $freeSpeditionPrice, 'remaining' => $remainingPrice];
	}

	// --------------- Slevove kody ------------

	/**
	 * @param $code
	 * @return bool
	 * @throws Exception
	 */
	public function checkValidDiscountCode($code): bool
	{
		return $this->cartSales->isValidDiscountCode($code, $this->cartsService->getCurrentCart()->getCartItemsPrice());
	}

	public function getDiscountTypeText($type)
	{
		return (($type == OrderDiscount::TYPE_PERCENT) ? ' %' : ' Kč');
	}

	public function countDiscountPrice($cartValue, $type = OrderDiscount::TYPE_PERCENT)
	{
		if ($type == OrderDiscount::TYPE_FIX) {
			$price = -$this->discountValue;
		} else {
			$discount = round($cartValue * $this->discountValue / 100);
			$price    = -$discount;
		}

		return $price;
	}

}

