<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use EshopCatalog\Model\Config as EshopCatalogConfig;
use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopCatalog\FrontModule\Model\Products;
use EshopOrders\FrontModule\Model\Dao\AddedCartItem;
use EshopOrders\FrontModule\Model\Event\AddedCartItemEvent;

class OrderFacade
{
	/** @var Orders */
	protected $orders;

	/** @var Carts */
	protected $carts;

	/** @var Products */
	protected $products;

	public function __construct(Orders $orders, Carts $carts, Products $products)
	{
		$this->orders   = $orders;
		$this->carts    = $carts;
		$this->products = $products;
	}

	public function repeatOrder(int $orderId): array
	{
		$result = [
			'status'      => 'ok',
			'added'       => 0,
			'notFound'    => 0,
			'notQuantity' => 0,
		];
		$order  = $this->orders->getDetail($orderId);
		$this->carts->clearCartItems();

		$products = [];
		foreach ($order['orderItems'] as $item) {
			$products[$item['productId']] = $this->products->get($item['productId']);
		}

		$this->products->loadQuantity($products);

		foreach ($order['orderItems'] as $item) {
			/** @var Product $product */
			$product = $products[$item['productId']];
			if (!$product) {
				$result['notFound']++;
				continue;
			}

			if (EshopCatalogConfig::load('pseudoWarehouse') && $item['quantity'] > $product->getQuantity()) {
				$result['notQuantity']++;
				$item['quantity'] = $product->getQuantity();
			}

			if ($item['quantity'] > 0) {
				$ci            = new AddedCartItem();
				$ci->productId = $item['productId'];
				$ci->quantity  = $item['quantity'];
				$ci->optionId  = $item['optionId'];
				$e             = new AddedCartItemEvent($ci);
				$this->carts->addItem($e);
				$result['added']++;
			}
		}

		if ($result['added'] === 0)
			$result['status'] = 'error';

		return $result;
	}
}
