<?php declare(strict_types=1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20190201155633 extends AbstractMigration
{
    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE eshop_orders__cart (id INT AUTO_INCREMENT NOT NULL, ident VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__cart_item (id INT AUTO_INCREMENT NOT NULL, cart_id INT DEFAULT NULL, ident VARCHAR(255) NOT NULL, product_id SMALLINT DEFAULT NULL, quantity SMALLINT NOT NULL, INDEX IDX_226E88EB1AD5CDBF (cart_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__customer (id INT AUTO_INCREMENT NOT NULL, user_id INT DEFAULT NULL, address_delivery INT DEFAULT NULL, address_invoice INT DEFAULT NULL, phone VARCHAR(255) DEFAULT NULL, UNIQUE INDEX UNIQ_1C11BF2FA76ED395 (user_id), UNIQUE INDEX UNIQ_1C11BF2FC90E1291 (address_delivery), UNIQUE INDEX UNIQ_1C11BF2FCB80E0DC (address_invoice), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__customer_address (id INT AUTO_INCREMENT NOT NULL, customer_id INT DEFAULT NULL, company VARCHAR(255) NOT NULL, street VARCHAR(255) NOT NULL, city VARCHAR(255) NOT NULL, postal VARCHAR(255) NOT NULL, INDEX IDX_E2F76AF29395C3F3 (customer_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__order (id INT AUTO_INCREMENT NOT NULL, customer_id INT DEFAULT NULL, payment INT DEFAULT NULL, spedition INT DEFAULT NULL, address_delivery_id INT DEFAULT NULL, address_invoice_id INT DEFAULT NULL, email VARCHAR(255) NOT NULL, phone VARCHAR(255) NOT NULL, message VARCHAR(255) NOT NULL, INDEX IDX_2888C07E9395C3F3 (customer_id), UNIQUE INDEX UNIQ_2888C07E6D28840D (payment), UNIQUE INDEX UNIQ_2888C07EB68ABD4F (spedition), UNIQUE INDEX UNIQ_2888C07E5DC4AEA (address_delivery_id), UNIQUE INDEX UNIQ_2888C07E51147963 (address_invoice_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__order_address (id INT AUTO_INCREMENT NOT NULL, type VARCHAR(255) NOT NULL, first_name VARCHAR(255) NOT NULL, last_name VARCHAR(255) NOT NULL, company VARCHAR(255) NOT NULL, street VARCHAR(255) NOT NULL, city VARCHAR(255) NOT NULL, postal VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__order_item (id INT AUTO_INCREMENT NOT NULL, order_id INT DEFAULT NULL, product_id SMALLINT DEFAULT NULL, quantity SMALLINT NOT NULL, price NUMERIC(10, 2) NOT NULL, INDEX IDX_C0EA013F8D9F6D38 (order_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__order_item_texts (lang VARCHAR(2) NOT NULL, id INT NOT NULL, name VARCHAR(255) NOT NULL, INDEX IDX_742C54F7BF396750 (id), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__order_payment (id INT AUTO_INCREMENT NOT NULL, payment_id INT DEFAULT NULL, order_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, price SMALLINT NOT NULL, INDEX IDX_6FF58B294C3A3BB (payment_id), UNIQUE INDEX UNIQ_6FF58B298D9F6D38 (order_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__order_spedition (id INT AUTO_INCREMENT NOT NULL, spedition_id INT DEFAULT NULL, order_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, price SMALLINT NOT NULL, INDEX IDX_D7DD43A54181B5B0 (spedition_id), UNIQUE INDEX UNIQ_D7DD43A58D9F6D38 (order_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__order_status (id INT AUTO_INCREMENT NOT NULL, order_id INT DEFAULT NULL, status_id VARCHAR(255) DEFAULT NULL, created_by INT DEFAULT NULL, created DATETIME NOT NULL, parameter VARCHAR(255) DEFAULT NULL, message VARCHAR(255) DEFAULT NULL, deleted TINYINT(1) DEFAULT NULL, INDEX IDX_CB9C4BDF8D9F6D38 (order_id), INDEX IDX_CB9C4BDF6BF700BD (status_id), INDEX IDX_CB9C4BDFDE12AB56 (created_by), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__payment (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, active VARCHAR(255) NOT NULL, sequence SMALLINT NOT NULL, price SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__spedition (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, text VARCHAR(255) NOT NULL, active VARCHAR(255) NOT NULL, sequence SMALLINT NOT NULL, price SMALLINT NOT NULL, logo VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eshop_orders__status (id VARCHAR(255) NOT NULL, name VARCHAR(255) NOT NULL, sequence SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE eshop_orders__cart_item ADD CONSTRAINT FK_226E88EB1AD5CDBF FOREIGN KEY (cart_id) REFERENCES eshop_orders__cart (id) ON DELETE SET NULL');
        $this->addSql('ALTER TABLE eshop_orders__customer ADD CONSTRAINT FK_1C11BF2FA76ED395 FOREIGN KEY (user_id) REFERENCES user (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_orders__customer ADD CONSTRAINT FK_1C11BF2FC90E1291 FOREIGN KEY (address_delivery) REFERENCES eshop_orders__customer_address (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_orders__customer ADD CONSTRAINT FK_1C11BF2FCB80E0DC FOREIGN KEY (address_invoice) REFERENCES eshop_orders__customer_address (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_orders__customer_address ADD CONSTRAINT FK_E2F76AF29395C3F3 FOREIGN KEY (customer_id) REFERENCES eshop_orders__customer (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_orders__order ADD CONSTRAINT FK_2888C07E9395C3F3 FOREIGN KEY (customer_id) REFERENCES eshop_orders__customer (id)');
        $this->addSql('ALTER TABLE eshop_orders__order ADD CONSTRAINT FK_2888C07E6D28840D FOREIGN KEY (payment) REFERENCES eshop_orders__order_payment (id)');
        $this->addSql('ALTER TABLE eshop_orders__order ADD CONSTRAINT FK_2888C07EB68ABD4F FOREIGN KEY (spedition) REFERENCES eshop_orders__order_spedition (id)');
        $this->addSql('ALTER TABLE eshop_orders__order ADD CONSTRAINT FK_2888C07E5DC4AEA FOREIGN KEY (address_delivery_id) REFERENCES eshop_orders__order_address (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_orders__order ADD CONSTRAINT FK_2888C07E51147963 FOREIGN KEY (address_invoice_id) REFERENCES eshop_orders__order_address (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_orders__order_item ADD CONSTRAINT FK_C0EA013F8D9F6D38 FOREIGN KEY (order_id) REFERENCES eshop_orders__order (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_orders__order_item_texts ADD CONSTRAINT FK_742C54F7BF396750 FOREIGN KEY (id) REFERENCES eshop_orders__order_item (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_orders__order_payment ADD CONSTRAINT FK_6FF58B294C3A3BB FOREIGN KEY (payment_id) REFERENCES eshop_orders__payment (id) ON DELETE SET NULL');
        $this->addSql('ALTER TABLE eshop_orders__order_payment ADD CONSTRAINT FK_6FF58B298D9F6D38 FOREIGN KEY (order_id) REFERENCES eshop_orders__order (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_orders__order_spedition ADD CONSTRAINT FK_D7DD43A54181B5B0 FOREIGN KEY (spedition_id) REFERENCES eshop_orders__spedition (id) ON DELETE SET NULL');
        $this->addSql('ALTER TABLE eshop_orders__order_spedition ADD CONSTRAINT FK_D7DD43A58D9F6D38 FOREIGN KEY (order_id) REFERENCES eshop_orders__order (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_orders__order_status ADD CONSTRAINT FK_CB9C4BDF8D9F6D38 FOREIGN KEY (order_id) REFERENCES eshop_orders__order (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_orders__order_status ADD CONSTRAINT FK_CB9C4BDF6BF700BD FOREIGN KEY (status_id) REFERENCES eshop_orders__status (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eshop_orders__order_status ADD CONSTRAINT FK_CB9C4BDFDE12AB56 FOREIGN KEY (created_by) REFERENCES user (id) ON DELETE SET NULL');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE eshop_orders__cart_item DROP FOREIGN KEY FK_226E88EB1AD5CDBF');
        $this->addSql('ALTER TABLE eshop_orders__customer_address DROP FOREIGN KEY FK_E2F76AF29395C3F3');
        $this->addSql('ALTER TABLE eshop_orders__order DROP FOREIGN KEY FK_2888C07E9395C3F3');
        $this->addSql('ALTER TABLE eshop_orders__customer DROP FOREIGN KEY FK_1C11BF2FC90E1291');
        $this->addSql('ALTER TABLE eshop_orders__customer DROP FOREIGN KEY FK_1C11BF2FCB80E0DC');
        $this->addSql('ALTER TABLE eshop_orders__order_item DROP FOREIGN KEY FK_C0EA013F8D9F6D38');
        $this->addSql('ALTER TABLE eshop_orders__order_payment DROP FOREIGN KEY FK_6FF58B298D9F6D38');
        $this->addSql('ALTER TABLE eshop_orders__order_spedition DROP FOREIGN KEY FK_D7DD43A58D9F6D38');
        $this->addSql('ALTER TABLE eshop_orders__order_status DROP FOREIGN KEY FK_CB9C4BDF8D9F6D38');
        $this->addSql('ALTER TABLE eshop_orders__order DROP FOREIGN KEY FK_2888C07E5DC4AEA');
        $this->addSql('ALTER TABLE eshop_orders__order DROP FOREIGN KEY FK_2888C07E51147963');
        $this->addSql('ALTER TABLE eshop_orders__order_item_texts DROP FOREIGN KEY FK_742C54F7BF396750');
        $this->addSql('ALTER TABLE eshop_orders__order DROP FOREIGN KEY FK_2888C07E6D28840D');
        $this->addSql('ALTER TABLE eshop_orders__order DROP FOREIGN KEY FK_2888C07EB68ABD4F');
        $this->addSql('ALTER TABLE eshop_orders__order_payment DROP FOREIGN KEY FK_6FF58B294C3A3BB');
        $this->addSql('ALTER TABLE eshop_orders__order_spedition DROP FOREIGN KEY FK_D7DD43A54181B5B0');
        $this->addSql('ALTER TABLE eshop_orders__order_status DROP FOREIGN KEY FK_CB9C4BDF6BF700BD');
        $this->addSql('DROP TABLE eshop_orders__cart');
        $this->addSql('DROP TABLE eshop_orders__cart_item');
        $this->addSql('DROP TABLE eshop_orders__customer');
        $this->addSql('DROP TABLE eshop_orders__customer_address');
        $this->addSql('DROP TABLE eshop_orders__order');
        $this->addSql('DROP TABLE eshop_orders__order_address');
        $this->addSql('DROP TABLE eshop_orders__order_item');
        $this->addSql('DROP TABLE eshop_orders__order_item_texts');
        $this->addSql('DROP TABLE eshop_orders__order_payment');
        $this->addSql('DROP TABLE eshop_orders__order_spedition');
        $this->addSql('DROP TABLE eshop_orders__order_status');
        $this->addSql('DROP TABLE eshop_orders__payment');
        $this->addSql('DROP TABLE eshop_orders__spedition');
        $this->addSql('DROP TABLE eshop_orders__status');
    }
}
